//	CMSound - an autonomous sound that plays itself

#include "CMSound.h"

#define AUDIO_SUBSCRIPTION_FAILED SUICIDE_NOTE"I couldn't connect to the audio server"

CMSound::CMSound(char *soundName, char *newSoundData, long soundLength)	
									//	constructor that takes 
									//	a pointer to the sound data
	: BSubscriber(soundName)				//	call the inherited constructor
	{
	theSoundData = framePointer = newSoundData;
									//	point them both to the sound
	tailEnd = theSoundData + soundLength;	//	set a sentinel to stop it
	alreadyPlaying = new CMSemaphore(soundName);
									//	create a semaphore for mutex access
	the_audio_stream = new BDACStream();	//	create a stream
	if (Subscribe(the_audio_stream) < B_NO_ERROR)
		cMass->FatalErrorAlert(AUDIO_SUBSCRIPTION_FAILED);
	the_audio_stream->SetSamplingRate(8000);
									//	set our sound parameters
     the_audio_stream->SetStreamBuffers(B_PAGE_SIZE, 8);
     								//	set the size of buffer & how many to use
     } // end of CMSound constructor	
	
CMSound::~CMSound()						//	destructor - releases the sound
	{
	alreadyPlaying->Acquire();			//	make sure it's done playing
	delete theSoundData;				//	release memory
	delete the_audio_stream;	
	delete alreadyPlaying;				//	delete the semaphore
	} // end of ~CMSound destructor	

void CMSound::Play()					//	plays the sound once
	{
	alreadyPlaying->Acquire();			//	make sure that it's not already playing
	EnterStream(0, true, this, _play_back, _done_playing, true);
	} // end of CMSound::Play()
	
bool CMSound::_play_back(void *arg, char *sound, size_t size, void *header)
									//	this is a glue function handed to the system
	{ 
     return (((CMSound *)arg)->Playback(sound, size)); 
     								//	size is how many bytes in the buffer
	} // end of glue function

bool CMSound::Playback(char *sound, long nBytes)
									//	this is called by the system to play each chunk
	{
	char *bufferPosition;				//	where we're copying to
	char *endOfChunk;					//	sentinel for buffering
	if (tailEnd - framePointer < nBytes)	//	if we're at the end of the sound
		endOfChunk = tailEnd;			// 	send what we've got left
	else // i.e. lots left
		endOfChunk = framePointer + nBytes;//	assume we fill it
	bufferPosition = sound;				//	start at the front of the buffer
     for ( ; framePointer < endOfChunk; framePointer++) 
     	{ 
		*bufferPosition = *framePointer;	//	copy a byte for the left channel
		bufferPosition++;				//	advance the pointer
     	}
	return (framePointer < tailEnd);		//	FALSE => done
	} // end of Playback()

long CMSound::_done_playing(void *arg, long error)
									//	glue code for DonePlaying
	{
	((CMSound *)arg)->DonePlaying();		//	go clean stuff up
	return B_NO_ERROR;					//	and say it's hunky-dory
	} // end of _done_playing()
		
void CMSound::DonePlaying()				//	cleans up when done
	{
	framePointer = theSoundData;			//	reset the frame pointer
	alreadyPlaying->Release();			//	and release the semaphore
	}